# SPDX-FileCopyrightText : 2023 Detlef Gebhardt, written for CircuitPython
# SPDX-FileCopyrightText : Copyright (c) 2023 Detlef Gebhardt
# SPDX-Filename          : 
# SPDX-License-Identifier: GEBMEDIA
import time
import board
import busio
import displayio
import terminalio
import fourwire
from adafruit_display_text import label
import gc9a01
import my_qmi8658

# Alle verwendeten Ressourcen freigeben
displayio.release_displays()
# Display initialisieren
spi = busio.SPI(clock=board.GP10, MOSI=board.GP11)
display_bus = fourwire.FourWire(spi, command=board.GP8, chip_select=board.GP9, reset=board.GP12)
display = gc9a01.GC9A01(display_bus, width=240, height=240, backlight_pin=board.GP25)
group1 = displayio.Group()
display.rotation = 90
display.brightness = 0.8

#display.show(group1)
# ab CircuitPython 9.0.x ersetzen durch
display.root_group = group1

# Sensor initialisieren
sensor=my_qmi8658.QMI8658()

# Hintergrundpalette
color_bitmap = displayio.Bitmap(240, 240, 1)
color_palette = displayio.Palette(1)
color_palette[0] = 0x800000
bg_sprite = displayio.TileGrid(color_bitmap, pixel_shader=color_palette, x=0, y=0)
group1.append(bg_sprite)

# Textausgabe
text1 = " rundes Display\n\n" + "1.28-Zoll-IPS-LCD\n\n" + "  240x240 Pixel"
updating_label1 = label.Label(font=terminalio.FONT, text=text1, scale=2, color=0xffffff, line_spacing=1)
updating_label1.anchor_point = (0, 0)
updating_label1.anchored_position = (20, 70)
group1.append(updating_label1)

while True:
    pass
