# SPDX-FileCopyrightText : 2023 Detlef Gebhardt, written for CircuitPython 10.0.0-beta
# SPDX-FileCopyrightText : Copyright (c) 2023 (updated 22.07.2025) Detlef Gebhardt
# SPDX-Filename          : Earth-Clock
import time
import rtc
import gc
import board
import busio
import displayio
import terminalio
import fourwire
from adafruit_display_text import label
from adafruit_display_shapes.roundrect import RoundRect
from adafruit_display_shapes.circle import Circle
import adafruit_imageload
from adafruit_ticks import ticks_ms
import math
import gc9a01
import my_qmi8658

# Alle verwendeten Ressourcen freigeben
displayio.release_displays()
# Display initialisieren
spi = busio.SPI(clock=board.GP10, MOSI=board.GP11)
display_bus = fourwire.FourWire(spi, command=board.GP8, chip_select=board.GP9, reset=board.GP12)
display = gc9a01.GC9A01(display_bus, width=240, height=240, backlight_pin=board.GP25)
group1 = displayio.Group()
main = displayio.Group()
display.rotation = 90
display.root_group = main

# Sensor initialisieren
sensor=my_qmi8658.QMI8658()

xpos = 120
ypos = 120
width = 240
height = 240
i = 0
j = -15

# Hintergrundbild
image1, palette = adafruit_imageload.load(
    "/images/erde.bmp", bitmap=displayio.Bitmap, palette=displayio.Palette)
tile_grid1 = displayio.TileGrid(image1, pixel_shader=palette)
main.append(tile_grid1)

# Rechteck mit abgerundeten Ecken
roundrect1 = RoundRect(60, 102, 120, 40, 10, fill=0x0, outline=0xffffff, stroke=3)
main.append(roundrect1)
# Label für die Zeitanzeige
updating_label1 = label.Label(font=terminalio.FONT, text="00:00:00", scale=2, color=0xffffff, line_spacing=1)
updating_label1.anchor_point = (0, 0)
updating_label1.anchored_position = (70, 110)
main.append(updating_label1)

# Ziffernring
for i in range(1,13,1):
    updating_label = label.Label(font=terminalio.FONT, text=str(i), scale=2, color=0xffff00, line_spacing=1)
    updating_label.anchor_point = (0, 0)
    if i<10:
        updating_label.anchored_position = (xpos-5+int(105*math.cos(-1*i*math.pi/6+ math.pi/2)),
                                        ypos-12-int(105*math.sin(-1*i*math.pi/6+ math.pi/2)))
    else:
        updating_label.anchored_position = (xpos-10+int(105*math.cos(-1*i*math.pi/6+ math.pi/2)),
                                        ypos-12-int(105*math.sin(-1*i*math.pi/6+ math.pi/2)))
    main.append(updating_label)

# Stundenpunkt
xpos_hour = int(width/2 + 65*math.cos(j*math.pi/30))
ypos_hour = int(height/2 + 65*math.sin(j*math.pi/30))
circle_hour = Circle(xpos_hour, ypos_hour, 8, fill=0xff0000, outline=0x000000)
main.append(circle_hour)
# Minutenpunkt
xpos_min = int(width/2 + 80*math.cos(j*math.pi/30))
ypos_min = int(height/2 + 80*math.sin(j*math.pi/30))
circle_min = Circle(xpos_min, ypos_min, 8, fill=0x00ff00, outline=0x000000 )
main.append(circle_min)
# Sekundenpunkt
xpos_sec = int(width/2 + 105*math.cos(j*math.pi/30))
ypos_sec = int(height/2 + 105*math.sin(j*math.pi/30))
circle_sec = Circle(xpos_sec, ypos_sec, 8, fill=0xffff00, outline=0x000000 )
main.append(circle_sec)

## Gruppe -group1- zum Stellen der Uhr
# Rechteck mit abgerundeten Ecken (Stellmodus)
roundrect1 = RoundRect(60, 100, 120, 40, 10, fill=0x0, outline=0xffffff, stroke=3)
group1.append(roundrect1)
# Label für Stellmodus
updating_set1 = label.Label(font=terminalio.FONT, text="stellen", scale=2, color=0xffffff, line_spacing=1)
updating_set1.anchor_point = (0, 0)
updating_set1.anchored_position = (70, 110)
group1.append(updating_set1)

current_time = time.localtime()
min_start = current_time.tm_min
hour_start = current_time.tm_hour
minute = current_time.tm_min
hour = current_time.tm_hour

## Start am PC oder stellen per Hand
if current_time.tm_min == 0 and current_time.tm_hour == 0:
    stellen = True
    blink = False
    display.root_group = group1
    time.sleep(1)
else:
    stellen = False
    display.root_group = main
    start = ticks_ms()
    blink = True

# Test zum stellen
#stellen = True
#display.root_group = group1

while True:
    #read QMI8658
    reading=sensor.Read_XYZ()   
    # Display wird um die x- und y-Achse gekippt
    wert_y = (10)*reading[0]
    wert_x = (10)*reading[1]
    if stellen == True:
        display.rotation = 90
        if blink == True:
            updating_set1.text = "{:02}:{:02}:00".format(hour_start,min_start)
            time.sleep(0.5)
            updating_set1.text = "00:00"
            time.sleep(0.5)
        # Minuten stellen
        if wert_y < -6:
            display.rotation = 0
            start = ticks_ms()
            blink = False
            if minute < 59:
                minute += 1
                time.sleep(0.6)
            else:
                minute = 0
                time.sleep(0.6)
            rt = rtc.RTC()
            rt.datetime = time.struct_time((2025, 1, 1, hour, minute, 0, 6, 1, -1))
            updating_set1.text = "{:02}:{:02}:00".format(hour,minute)
        # Stunden stellen
        if wert_y > 6:
            display.rotation = 180
            start = ticks_ms()
            blink = False
            if hour < 23:
                hour += 1
                time.sleep(0.6)
            else:
                hour = 0
                time.sleep(0.6)
            rt = rtc.RTC()
            rt.datetime = time.struct_time((2025, 1, 1, hour, minute, 0, 6, 1, -1))
            updating_set1.text = "{:02}:{:02}:00".format(hour,minute)
        ## Uhrzeit einstellen abschliessen
        if wert_y > -2 and wert_y < 2 and wert_x > -3 and wert_x < 3:
            display.rotation = 90
            stellen = False
            rt = rtc.RTC()
            rt.datetime = time.struct_time((2025, 1, 1, hour, minute, 0, 6, 1, -1))
            display.root_group = main  
    else:
        current_time = time.localtime()
        hour = current_time.tm_hour
        minute = current_time.tm_min
        sec = current_time.tm_sec
        # Minuten-, Stunden- und Sekundenpunkt setzen    
        # Minuten
        xpos_min_neu = int(width/2 + 80*math.cos((minute-15)*math.pi/30))
        delta_min_x = xpos_min_neu - xpos_min
        xpos_min = xpos_min_neu
        ypos_min_neu = int(height/2 + 80*math.sin((minute-15)*math.pi/30))
        delta_min_y = ypos_min_neu - ypos_min
        ypos_min = ypos_min_neu
        circle_min.x = circle_min.x + delta_min_x
        circle_min.y = circle_min.y + delta_min_y
        # Stunden
        xpos_hour_neu = int(width/2 + int(65*math.cos((hour)*math.pi/6 + minute/2*math.pi/180 - math.pi/2)))
        delta_hour_x = xpos_hour_neu - xpos_hour
        xpos_hour = xpos_hour_neu
        ypos_hour_neu = int(height/2 + int(65*math.sin((hour)*math.pi/6 + minute/2*math.pi/180 - math.pi/2)))
        delta_hour_y = ypos_hour_neu - ypos_hour
        ypos_hour = ypos_hour_neu
        circle_hour.x = circle_hour.x + delta_hour_x
        circle_hour.y = circle_hour.y + delta_hour_y
        # Sekunden
        xpos_sec_neu = int(width/2 + int(105*math.cos((sec-15)*math.pi/30)))
        delta_sec_x = xpos_sec_neu - xpos_sec
        xpos_sec = xpos_sec_neu
        ypos_sec_neu = int(height/2 + int(105*math.sin((sec-15)*math.pi/30)))
        delta_sec_y = ypos_sec_neu - ypos_sec
        ypos_sec = ypos_sec_neu
        circle_sec.x = circle_sec.x + delta_sec_x
        circle_sec.y = circle_sec.y + delta_sec_y
        #
        # Zeitstring zur Anzeige aufbereiten
        # 
        updating_label1.text = "{:02}:{:02}:{:02}".format(current_time.tm_hour,current_time.tm_min,current_time.tm_sec)
